/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.fuelacceptor;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.content.nuclear.reactor.RodFindingReactorBlockEntity;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlockEntity;

public abstract class ReactorFuelAcceptorBlockEntity
extends RodFindingReactorBlockEntity {
    public class_1277 container = new FuelAcceptorContainer(3);
    int ticks = 0;

    public ReactorFuelAcceptorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("contents", (class_2520)this.container.method_7660());
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.container.method_7659(compound.method_10554("contents", 10));
        super.read(compound, clientPacket);
    }

    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)this.container.method_5438(i));
        }
    }

    public void tick(class_2338 pos, class_1937 world, class_2680 state) {
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = 20;
            LinkedList<ReactorRodBlockEntity> rods = new LinkedList<ReactorRodBlockEntity>();
            for (class_2350 dir : class_2350.values()) {
                this.findRods(rods, dir);
            }
            if (rods.isEmpty()) {
                return;
            }
            AtomicInteger have = new AtomicInteger();
            int hadBefore = 0;
            for (ReactorRodBlockEntity rod : rods) {
                hadBefore += rod.fuel;
            }
            AtomicInteger totalNeeded = new AtomicInteger(345600 * rods.size() - hadBefore);
            for (int i = 0; i < this.container.method_5439(); ++i) {
                class_1799 stack = this.container.method_5438(i);
                if (!stack.method_31573(CNATags.Item.NUCLEAR_FUEL.tag)) continue;
                stack.method_40133().forEach(itemTagKey -> {
                    String path;
                    if (itemTagKey.comp_327().method_12836().equals("create_new_age") && (path = itemTagKey.comp_327().method_12832()).startsWith("nuclear/energy_")) {
                        try {
                            int energy = Integer.parseInt(path.substring(15));
                            int total = (int)Math.min((double)stack.method_7947(), (double)(totalNeeded.get() / energy));
                            totalNeeded.addAndGet(-energy * total);
                            have.addAndGet(energy * total);
                            stack.method_7934(total);
                        }
                        catch (NumberFormatException e) {
                            CreateNewAge.LOGGER.error("BAD TAG " + itemTagKey + " on item " + stack.method_7954().getString(), (Throwable)e);
                        }
                    }
                });
            }
            this.method_5431();
            int target = (hadBefore + have.get()) / rods.size();
            for (ReactorRodBlockEntity rod : rods) {
                rod.fuel = target;
            }
        }
    }

    private class FuelAcceptorContainer
    extends class_1277 {
        FuelAcceptorContainer(int size) {
            super(size);
        }

        public boolean method_5437(int index, class_1799 stack) {
            return stack.method_31573(CNATags.Item.NUCLEAR_FUEL.tag);
        }
    }
}

